#!/bin/sh

TP_CHECKLIST_OK_CANCEL_RESULT_NULL="DTAS[TUI]@{NULL}"
TP_CHECKLIST_OK_CANCEL_RESULT_SELECT=""

TP_CHECKLIST_OK_CANCEL_RESULT_OK="DTAS[TUI]@{OK}"
TP_CHECKLIST_OK_CANCEL_RESULT_CANCEL="DTAS[TUI]@{CANCEL}"
TP_CHECKLIST_OK_CANCEL_RESULT_ERROR="DTAS[TUI]@{ERROR}"
TP_CHECKLIST_OK_CANCEL_RESULT_CODE=""

TP_CHECKLIST_OK_CANCEL_RESULT_MSG=""

tp_checklist_ok_cancel() {
	local title="${1}"
	local text="${2}"
	local ok_label="${3}"
    local cancel_label="${4}"
    local list="${5}"

    # debug_print "title: ${title}"
    # debug_print "text: ${text}"
    # debug_print "ok_label: ${ok_label}"
    # debug_print "cancel_label: ${cancel_label}"
    # debug_print "list: ${list}"

    exec 3>&1
    local ret=`sh -c "dialog \
        --backtitle    \"${CONS_BACK_TITLE}\" \
        --title        \"${title}\" \
        --ok-label     \"${ok_label}\" \
        --cancel-label \"${cancel_label}\" \
        --checklist    \"${text}\" \
                       \"${CONS_BOX_HEIGHT}\" \
                       \"${CONS_BOX_WIDTH}\" \
                       20 \
                       ${list} \
        2>&1 1>&3"; \
        case "${?}" in \
            1|255) echo "${TP_CHECKLIST_OK_CANCEL_RESULT_CANCEL}" ;; \
        esac`
	exec 3>&-

    
    ##################################################
    # press "CANCEL" or "ESC"
    ##################################################
    case "${ret}" in
        "${TP_CHECKLIST_OK_CANCEL_RESULT_CANCEL}" )
            TP_CHECKLIST_OK_CANCEL_RESULT_CODE="${TP_CHECKLIST_OK_CANCEL_RESULT_CANCEL}"
            TP_CHECKLIST_OK_CANCEL_RESULT_SELECT="${TP_CHECKLIST_OK_CANCEL_RESULT_NULL}"
            TP_CHECKLIST_OK_CANCEL_RESULT_MSG=""
            return
            ;;
    esac

    TP_CHECKLIST_OK_CANCEL_RESULT_CODE="${TP_CHECKLIST_OK_CANCEL_RESULT_OK}"
    TP_CHECKLIST_OK_CANCEL_RESULT_SELECT="${ret}"
    TP_CHECKLIST_OK_CANCEL_RESULT_MSG=""
    return
}

